#!/usr/bin/perl
#
# Copyright (C) 2002 USUDA Hisashi, All Rights Reserved.
#
require "getopts.pl";
use Net::DNS;

sub ipres_init {
    $res = new Net::DNS::Resolver;
}

sub ipres {
    my($name) = @_;
    my($ret, $query, $rr);

    if(! $dnsres{$name}) {
	$ret = "";
	$query = $res->query($name, 'PTR', 'IN');
	if($query) {
	    foreach $rr ($query->answer) {
		next if $rr->type ne "PTR";
		$ret .= $rr->ptrdname . ",";
	    }
	}
	$dnsres{$name} = $ret eq "" ? "-":substr($ret, 0, -1);
	$dnsres{$name} = $ret eq "" ? "-":substr($ret, 0, -1);
    }
    $dnsres{$name} eq "-" ? "":sprintf("(%s)", $dnsres{$name});
}

sub print_graph {
    my($port, $cnt, $max) = @_;
    my($l) = (int 50.*$cnt/$max);

    printf("%13s |", $port);
    print '*' x $l;
    print '-' x (50-$l);
    printf("|%8d\n", $cnt);
}

sub usage {
    print STDERR "Usage: ipmonchk.pl [-d][-h][-n][-p port[,port,...]][-s address]\n";
    exit 1;
}

###

&Getopts('dhnp:s:');
&usage if $opt_h;
&ipres_init unless $opt_n;

@ignore_ports = split(/,/, $opt_p);
if(@ignore_ports) {
    printf("## Ignore the following ports: %s\n", join(", ", @ignore_ports));
}

$ATK_PRT_MAX = 0;
while(<>) {
    chop;

    # ipmon[PID]: HH:MM:SS.UUUUUU IF @MM:SS b IP,PORT -> IP,PORT ...
    if (/ipmon\[\d+\]:\s+\d+:\d+:\d+\.\d+\s+\S+\s+\@\S+\s+\S+\s+(\d+\.\d+\.\d+\.\d+),(\d+)\s+\S+\s+(\d+\.\d+\.\d+\.\d+),(\d+)\s+\S+\s+(\S+)/) {
	$PRT_COUNT{"$4/$5"}++;
	next if grep($_ eq $4, @ignore_ports);
	$DTL_COUNT{"$5:$1:$2:$3:$4"}++;
	$ATK_COUNT{"$1"}++;
	if(++$ATK_PRT_COUNT{"$1:$4/$5"} > $ATK_PRT_MAX) {
	    $ATK_PRT_MAX = $ATK_PRT_COUNT{"$1:$4/$5"};
	}
	$DEF_COUNT{"$3"}++;
    }
}

print "\n*** Defenders and counts...\n\n";
foreach $val (sort { $DEF_COUNT{$b} <=> $DEF_COUNT{$a} } keys %DEF_COUNT) {
    if($opt_n) {
	printf("  %-15s : %8d\n", $val, $DEF_COUNT{$val});
    } else {
	printf("  %-15s : %8d   %s\n", $val, $DEF_COUNT{$val}, &ipres($val));
    }
}

print "\n*** Attacked ports and counts...\n\n";
foreach $val (sort { $PRT_COUNT{$b} <=> $PRT_COUNT{$a} } keys %PRT_COUNT) {
    printf("  %10s : %8d\n", $val, $PRT_COUNT{$val});
}

print "\n*** Attackers and counts...\n\n";
foreach $val (sort { $ATK_COUNT{$b} <=> $ATK_COUNT{$a} } keys %ATK_COUNT) {
    if($opt_n) {
	printf("  %-15s : %8d\n", $val, $ATK_COUNT{$val});
    } else {
	printf("  %-15s : %8d  %s\n", $val, $ATK_COUNT{$val}, &ipres($val));
    }
    foreach $pval (sort { $ATK_PRT_COUNT{$b} <=> $ATK_PRT_COUNT{$a} }
	keys %ATK_PRT_COUNT) {
	next unless $pval =~ /^$val:(\d+\/\S+)/;
	&print_graph($1, $ATK_PRT_COUNT{$pval}, $ATK_PRT_MAX);
    }
}

if($opt_d) {
    print "\n*** Details...\n\n";
    foreach $val (sort { $DTL_COUNT{$b} <=> $DTL_COUNT{$a} } keys %DTL_COUNT) {
	($proto, $srcip, $srcport, $dstip, $dstport) = split(':', $val);
	printf("  %-15s:%5s -> %-15s:%5s/%3s : %8d\n",
		$srcip, $srcport, $dstip, $dstport, $proto, $DTL_COUNT{$val});
    }
}

if($opt_s) {
    print "\n-- \n Generated by ipmonchk.pl v0.81 - mailto:$opt_s\n";
}
