#!/usr/bin/perl
#
# This file is subject to the terms and conditions of the GNU
# General Public License.  See the file "COPYING" in the main
# directory of this archive for more details.
#
# Copyright (c) 2003 by USUDA Hisashi <usu@d1.dion.ne.jp>

use strict;
use POSIX qw(strftime);
use CGI;
require 'jcode.pl';

sub trans_data {
    my($data, $retcode, $ocode) = @_;

    jcode::convert(*data, $ocode) if $ocode;
    $data =~ s/\r\n/\n/mg;
    $data =~ s/\r/\n/mg;
    $data =~ s/\n/$retcode/mg;
    $data;
}

sub write_csv {
    my($cgi, $name, $retcode, $ocode, $dformat, $paramname, $envname) = @_;
    my($fname, $key, $k, @val, @ar, $exist, $hed, $ret);

    if($name =~ /\%/) {
	$fname = strftime($name, localtime);
    } else {
	$fname = $name;
    }
    $exist = stat($fname);
    if(! open(FILE, ">>$fname")) {
	return "Error: cannot open.";
    } else {
	if($dformat) {
	    $hed = "\"date\",";
	    $ret = "\"" . strftime($dformat, localtime) . "\",";
	}
	if($paramname) {
	    @ar = split(':', $paramname);
	    for(@ar) {
		@val = $cgi->param($_);
		$hed .= "\"$_\",";
		$ret .= "\"" . join(",", @val) . "\",";
	    }
	} else {
	    for $key ($cgi->param()) {
		@val = $cgi->param($key);
		$hed .= "\"$key\",";
		$ret .= "\"" . join(",", @val) . "\",";
	    }
	}

	if($envname) {
	    @ar = split(':', $envname);
	    for(@ar) {
		$hed .= "\"$_\",";
		$ret .= "\"" . $ENV{$_} . "\",";
	    }
	}

	$hed = &trans_data(substr($hed, 0, -1), $retcode, $ocode);
	$ret = &trans_data(substr($ret, 0, -1), $retcode, $ocode);
	flock(FILE, 2);
	print FILE "$hed\n" unless $exist;
	print FILE "$ret\n";
	flock(FILE, 8);
	close FILE;
    }
    return "OK$ret";
}

sub send_mail {
    my($cgi, $from, $to, $cont, $ret) = @_;
    my(@cmdpath) = ("/usr/lib/sendmail", "/usr/sbin/sendmail");
    my($sendmail, $str);
    my(@ar, @val);

    for(@cmdpath) {
	if(-x $_) {
	    $sendmail = $_;
	    last;
	}
    }
    return 0 if $sendmail eq "";

    $str  = "From: $from\nTo: $to\n";
    if($ENV{'SERVER_PORT'} == 80) {
	$str .= "Subject: Result of $ENV{'SERVER_NAME'}$ENV{'REQUEST_URI'}\n";
    } else {
	$str .= "Subject: Result of $ENV{'SERVER_NAME'}:$ENV{'SERVER_PORT'}$ENV{'REQUEST_URI'}\n";
    }
    $str .= "X-Mailer: csvcgi.pl v0.51\n\n$ret\n\n";
    if($cont) {
	@ar = split(':', $cont);
	for(@ar) {
	    @val = $cgi->param($_);
	    $str .= "$_ : " . join(",", @val) . "\n";
	}
    }
    $str .= "-- \n csvcgi.pl - $from\n";

    if(open(MAIL, "|$sendmail $to")) {
	print MAIL jcode::jis($str);
	close MAIL;
    }
}

###

sub csvcgi {
    my($csvfile, $retcode, $ocode, $dformat, $paramname, $envname,
       $okurl, $ngurl, $from, $to, $contname) = @_;
    my $cgi = CGI->new();
    my($ret);

    $ret = &write_csv($cgi, $csvfile, $retcode, $ocode, $dformat, $paramname, $envname);

    if($ret =~ /^OK(.*)$/) {
	$ret = "OK"; # ignore output string
	if($okurl ne "") {
		print $cgi->redirect($okurl);
	} else {
		print $cgi->header();
	}
    } else {
	if($ngurl ne "") {
		print $cgi->redirect($ngurl);
	} else {
		print $cgi->header();
	}
    }
    print $cgi->start_html($ret);
    print $ret;
    print $cgi->end_html();

    if($from && $to) {
	&send_mail($cgi, $from, $to, $contname, $ret);
    }
}

1;
